//----------------------------------------------------------------------------//
//- CaoListeVonArtikelListen.pas ---------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Stellt ein Listenobjekt dar, das wiederum ArtikelListen enthlt            //
//----------------------------------------------------------------------------//

unit CaoListeVonArtikelListen;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Contnrs, CaoArtikelListe;

//------------------------------------------------------------------------------

type
  TCaoListeVonArtikelListen = class (TObject)

  //----------------------------------------------------------------------------

  private
    m_obListe : TObjectList;
    function  GetItems(iIndex: Integer): TCaoArtikelListe;
    procedure SetItems(iIndex: Integer; Value: TCaoArtikelListe);

  //----------------------------------------------------------------------------

  public
    property Items[iIndex: Integer]: TCaoArtikelListe read  GetItems
                                                      write SetItems;

    //--------------------------------------------------------------------------

    constructor Create;  reintroduce;
    destructor  Destroy; reintroduce;
    function    CreateArtikelListe: TCaoArtikelListe;

  //----------------------------------------------------------------------------

  end; // TCaoListeVonArtikelListen

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

constructor TCaoListeVonArtikelListen.Create;
begin
  inherited Create;
  m_obListe := TObjectList.Create;
end; // TCaoListeVonArtikelListen.Create

//------------------------------------------------------------------------------

destructor TCaoListeVonArtikelListen.Destroy;
begin
  m_obListe.Free;
  inherited Destroy;
end; // TCaoListeVonArtikelListen.Destroy

//------------------------------------------------------------------------------

function TCaoListeVonArtikelListen.GetItems(iIndex: Integer): TCaoArtikelListe;
begin
  Result := TCaoArtikelListe(m_obListe[iIndex]);
end; // TCaoListeVonArtikelListen.GetItems

//------------------------------------------------------------------------------

procedure TCaoListeVonArtikelListen.SetItems(iIndex: Integer;
                                             Value : TCaoArtikelListe);
begin
  m_obListe[iIndex] := Value;
end; // TCaoListeVonArtikelListen.SetItems

//------------------------------------------------------------------------------

function TCaoListeVonArtikelListen.CreateArtikelListe: TCaoArtikelListe;
(*
  Erzeugen einer neuen ArtikelListe. Das Objekt wird gleichzeitig m_obListe
  hinzugefgt.
*)
begin
  Result         := TCaoArtikelListe.Create;
  m_obListe.Add(Result);
end; // TCaoListeVonArtikelListen.CreateArtikelListe

//------------------------------------------------------------------------------

end. // CaoListeVonArtikelListen
